# Priority Definition Planning



* [**Priority Definition Planning - Pre-ATT&CK**](https://attack.mitre.org/pre-attack/index.php/Priority_Definition_Planning)
	* Priority definition planning consists of the process of determining the set of Key Intelligence Topics (KIT) or Key Intelligence Questions (KIQ) required for meeting key strategic, operational, or tactical goals. Leadership outlines the priority definition (may be considered a goal) around which the adversary designs target selection and a plan to achieve. An analyst may outline the priority definition when in the course of determining gaps in existing KITs or KIQs.




-------------------------------
## Assess KITs/KIQs benefits
* [Assess KITs/KIQs benefits - Pre-ATT&CK](https://attack.mitre.org/pre-attack/index.php/Technique/PRE-T1006)
	* Key Intelligence Topics (KITs) and Key Intelligence Questions (KIQs) may be further subdivided to focus on political, economic, diplomatic, military, financial, or intellectual property categories. An adversary may specify KITs or KIQs in this manner in order to understand how the information they are pursuing can have multiple uses and to consider all aspects of the types of information they need to target for a particular purpose. 





-------------------------------
## Assess current holdings, needs, and wants
* [Assess current holdings, needs, and wants - Pre-ATT&CK](https://attack.mitre.org/pre-attack/index.php/Technique/PRE-T1013)
	* Analysts assess current information available against requirements that outline needs and wants as part of the research baselining process to begin satisfying a requirement.




-------------------------------
## Assess leadership areas of interest
* [Assess leadership areas of interest - Pre-ATT&CK](https://attack.mitre.org/pre-attack/index.php/Technique/PRE-T1001)
	* Leadership assesses the areas of most interest to them and generates Key Intelligence Topics (KIT) or Key Intelligence Questions (KIQ). For example, an adversary knows from open and closed source reporting that cyber is of interest, resulting in it being a KIT.




-------------------------------
## Assign KITs/KIQs into categories
* [Assign KITs/KIQs into categories - Pre-ATT&CK](https://attack.mitre.org/wiki/Technique/T1123)
	* Leadership organizes Key Intelligence Topics (KITs) and Key Intelligence Questions (KIQs) into three types of categories and creates more if necessary. An example of a description of key players KIT would be when an adversary assesses the cyber defensive capabilities of a nation-state threat actor.



-------------------------------
## Conduct cost/benefit analysis
* [Conduct cost/benefit analysis - Pre-ATT&CK](https://attack.mitre.org/pre-attack/index.php/Technique/PRE-T1003)
	* Leadership conducts a cost/benefit analysis that generates a compelling need for information gathering which triggers a Key Intelligence Toptic (KIT) or Key Intelligence Question (KIQ). For example, an adversary compares the cost of cyber intrusions with the expected benefits from increased intelligence collection on cyber adversaries.


-------------------------------
## Create implementation plan
* [Create implementation plan - Pre-ATT&CK](https://attack.mitre.org/pre-attack/index.php/Technique/PRE-T1009)
	* Implementation plans specify how the goals of the strategic plan will be executed.



-------------------------------
## Create strategic plan
* [Create strategic plan - Pre-ATT&CK](https://attack.mitre.org/pre-attack/index.php/Technique/PRE-T1008)
	* Strategic plans outline the mission, vision, and goals for an adversary at a high level in relation to the key partners, topics, and functions the adversary carries out.





-------------------------------
## Derive intelligence requirements
* [Derive intelligence requirements - Pre-ATT&CK](https://attack.mitre.org/pre-attack/index.php/Technique/PRE-T1007)
	* Leadership or key decision makers may derive specific intelligence requirements from Key Intelligence Topics (KITs) or Key Intelligence Questions (KIQs). Specific intelligence requirements assist analysts in gathering information to establish a baseline of information about a topic or question and collection managers to clarify the types of information that should be collected to satisfy the requirement.




-------------------------------
## Develop KITs/KIQs
* [Develop KITs/KIQs](https://attack.mitre.org/pre-attack/index.php/Technique/PRE-T1004)
	* Leadership derives Key Intelligence Topics (KITs) and Key Intelligence Questions (KIQs) from the areas of most interest to them. KITs are an expression of management's intelligence needs with respect to early warning, strategic and operational decisions, knowing the competition, and understanding the competitive situation. KIQs are the critical questions aligned by KIT which provide the basis for collection plans, create a context for analytic work, and/or identify necessary external operations.




-------------------------------
## Generate analyst intelligence requirements
* [Generate analyst intelligence requirements - Pre-ATT&CK](https://attack.mitre.org/pre-attack/index.php/Technique/PRE-T1011)
	* Analysts may receive Key Intelligence Topics (KITs) and Key Intelligence Questions (KIQs) from leadership or key decision makers and generate intelligence requirements to articulate intricacies of information required on a topic or question.


-------------------------------
## Identify analyst level gaps
* [Identify analyst level gaps - Pre-ATT&CK](https://attack.mitre.org/pre-attack/index.php/Technique/PRE-T1010)
	* Analysts identify gap areas that generate a compelling need to generate a Key Intelligence Topic (KIT) or Key Intelligence Question (KIQ).






-------------------------------
## Identify gap areas
* [Identify gap areas](https://attack.mitre.org/pre-attack/index.php/Technique/PRE-T1002)
	* Leadership identifies gap areas that generate a compelling need to generate a Key Intelligence Topic (KIT) or Key Intelligence Question (KIQ).





-------------------------------
## Receive operator KITs/KIQs tasking
* [Receive operator KITs/KIQs tasking - Pre-ATT&CK](https://attack.mitre.org/pre-attack/index.php/Technique/PRE-T1012)
	* Analysts may receive intelligence requirements from leadership and begin research process to satisfy a requirement. Part of this process may include delineating between needs and wants and thinking through all the possible aspects associating with satisfying a requirement.








